﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Workflow.Activities.Rules;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.Activities.Rules.Design;
using System.Xml;
using System.IO;

namespace Lessons.Workflows
{

    /* a static class which encapsulates a part of the rules engine functionality provided by the WWF */
    static public class RulesEngine
    {

        /* taken from http://blog.tfanshteyn.com/2007/08/tweaking-rulesetdialog-to-resize.html */
        static void ConvertToResizable(RuleSetDialog Dlg)
        {
            Dlg.FormBorderStyle = FormBorderStyle.Sizable;
            Dlg.HelpButton = false;
            Dlg.MaximizeBox = true;
            Dlg.Controls["okCancelTableLayoutPanel"].Anchor = AnchorStyles.Right | AnchorStyles.Bottom;
            Dlg.Controls["rulesGroupBox"].Anchor = AnchorStyles.Left | AnchorStyles.Top | AnchorStyles.Right;
            Dlg.Controls["ruleGroupBox"].Anchor = AnchorStyles.Left | AnchorStyles.Top | AnchorStyles.Right | AnchorStyles.Bottom;
            Dlg.Controls["ruleGroupBox"].Controls["thenTextBox"].Anchor = AnchorStyles.Left |
                                                                                    AnchorStyles.Top |
                                                                                    AnchorStyles.Right | AnchorStyles.Bottom;
            Dlg.Controls["ruleGroupBox"].Controls["elseLabel"].Anchor = AnchorStyles.Left | AnchorStyles.Bottom;
            Dlg.Controls["ruleGroupBox"].Controls["elseTextBox"].Anchor = AnchorStyles.Left | AnchorStyles.Right | AnchorStyles.Bottom;
            Dlg.Controls["ruleGroupBox"].Controls["conditionTextBox"].Anchor = AnchorStyles.Left |
                                                                                         AnchorStyles.Top |
                                                                                         AnchorStyles.Right;

            Dlg.Controls["rulesGroupBox"].Controls["panel1"].Anchor = AnchorStyles.Left | AnchorStyles.Top | AnchorStyles.Right;
            Dlg.Controls["rulesGroupBox"].Controls["panel1"].Controls["chainingBehaviourComboBox"].Anchor = AnchorStyles.Top | AnchorStyles.Right;
            Dlg.Controls["rulesGroupBox"].Controls["panel1"].Controls["chainingLabel"].Anchor = AnchorStyles.Top | AnchorStyles.Right;
        }

        /* executes RuleSet rules against Instance */
        static public void Execute(RuleSet RuleSet, object Instance)
        {
            if (RuleSet == null)
                throw new ArgumentNullException("RuleSet");

            if (Instance == null)
                throw new ArgumentNullException("Instance");

            RuleValidation ruleValidation = new RuleValidation(Instance.GetType(), null);
            RuleExecution ruleExecution = new RuleExecution(ruleValidation, Instance);
            RuleSet.Execute(ruleExecution);
        }


        /* Saves RuleSet to FileName */
        static public void SaveToFile(RuleSet RuleSet, string FileName)
        {
            using (XmlWriter rulesWriter = XmlWriter.Create(FileName))
            {
                WorkflowMarkupSerializer serializer = new WorkflowMarkupSerializer();
                serializer.Serialize(rulesWriter, RuleSet);
            }
        }

        /* Loads and returns a RuleSet from FileName */
        static public RuleSet LoadFromFile(string FileName)
        {
            using (XmlTextReader rulesReader = new XmlTextReader(FileName))
            {
                WorkflowMarkupSerializer serializer = new WorkflowMarkupSerializer();
                return serializer.Deserialize(rulesReader) as RuleSet;
            }
        }

        /* Returns the RuleSet converted to XML text */
        static public string ToText(RuleSet RuleSet)
        {
            StringBuilder SB = new StringBuilder();
            using (XmlWriter writer = XmlWriter.Create(SB))
            {
                WorkflowMarkupSerializer serializer = new WorkflowMarkupSerializer();
                serializer.Serialize(writer, RuleSet);
            }
            return SB.ToString();
        }


        /* Returns a RuleSet reading the rules in Text */
        static public RuleSet FromText(string Text)
        {
            RuleSet Result = null;
            if (!string.IsNullOrEmpty(Text))
            {
                using (XmlReader reader = XmlReader.Create(new StringReader(Text)))
                {
                    WorkflowMarkupSerializer serializer = new WorkflowMarkupSerializer();
                    Result = serializer.Deserialize(reader) as RuleSet;
                }
            }
            return Result;
        }


        /*  Displays the RuleSetDialog for editing RuleSet regarding InstanceType.  
            Returns true if the user clicks the OK button */
        static public bool DisplayDialog(Type InstanceType, ref RuleSet RuleSet)
        {
            bool Result = false;

            using (RuleSetDialog Dlg = new RuleSetDialog(InstanceType, null, RuleSet))
            {
                ConvertToResizable(Dlg);

                Result = Dlg.ShowDialog() == DialogResult.OK;
                if (Result)
                    RuleSet = Dlg.RuleSet;
            }

            return Result;
        }
    }


}
